/*
 * Decompiled with CFR 0.152.
 */
package drawincode;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class BackgroundPanel
extends JPanel {
    private BufferedImage backgroundImage;

    public BackgroundPanel() {
        this.setPreferredSize(new Dimension(148, 64));
        this.setSize(new Dimension(148, 64));
        this.setOpaque(false);
        this.init();
    }

    private void init() {
        this.backgroundImage = null;
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.backgroundImage = null;
        this.repaint();
    }

    public void setSize(Dimension dim) {
        super.setSize(dim);
        this.backgroundImage = null;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.backgroundImage == null) {
            this.backgroundImage = this.createBackgroundImage();
        }
        g2.drawImage((Image)this.backgroundImage, 0, 0, null);
        g2.dispose();
    }

    private BufferedImage createBackgroundImage() {
        GraphicsConfiguration gfxConf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage IMAGE = gfxConf.createCompatibleImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D g2 = IMAGE.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point2D.Double BACKGROUND_START = new Point2D.Double(0.0, 0.0);
        Point2D.Double BACKGROUND_STOP = new Point2D.Double(0.0, this.getHeight());
        float[] BACKGROUND_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] BACKGROUND_COLORS = new Color[]{new Color(0xAAAAAA), new Color(0x888888)};
        RoundRectangle2D.Double BACKGROUND = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight(), 10.0, 10.0);
        LinearGradientPaint BACKGROUND_GRADIENT = new LinearGradientPaint(BACKGROUND_START, BACKGROUND_STOP, BACKGROUND_FRACTIONS, BACKGROUND_COLORS);
        g2.setPaint(BACKGROUND_GRADIENT);
        g2.fill(BACKGROUND);
        g2.dispose();
        return IMAGE;
    }
}

