/*
 * Draw on code tutorial which hopefully will
 * be helpfull in understanding how to create
 * custom components in swing
 */

package drawincode;

/**
 *
 * @author hansolo
 */
public class NixieTube extends javax.swing.JComponent
{
    private final java.awt.image.BufferedImage TUBE_IMAGE = createTubeImage();

    public NixieTube()
    {
        super();        
    }

    @Override
    protected void paintComponent(java.awt.Graphics g)
    {
        g.drawImage(TUBE_IMAGE, 0, 0, null);
    }

    private java.awt.image.BufferedImage createTubeImage()
    {
        // Create a buffered image object
        java.awt.GraphicsConfiguration gfxConf = java.awt.GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        final java.awt.image.BufferedImage IMAGE = gfxConf.createCompatibleImage(86, 146, java.awt.Transparency.TRANSLUCENT);


        // Get the graphics2d object from the image
        java.awt.Graphics2D g2 = IMAGE.createGraphics();


        // Set all the needed rendering hints
        g2.setRenderingHint(java.awt.RenderingHints.KEY_ANTIALIASING, java.awt.RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(java.awt.RenderingHints.KEY_ALPHA_INTERPOLATION, java.awt.RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.setRenderingHint(java.awt.RenderingHints.KEY_COLOR_RENDERING, java.awt.RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setRenderingHint(java.awt.RenderingHints.KEY_STROKE_CONTROL, java.awt.RenderingHints.VALUE_STROKE_PURE);


        /**
         * Tutorial Step 1. - 5.
         * Create the glass tube form
         */
        final java.awt.geom.Area TUBE = new java.awt.geom.Area(new java.awt.geom.RoundRectangle2D.Float(1, 8, 86, 136, 86, 86));
        final java.awt.geom.Area TUBE_BOTTOM = new java.awt.geom.Area(new java.awt.geom.RoundRectangle2D.Float(1, 75, 86, 70, 30, 30));
        final java.awt.geom.Area TUBE_TOP = new java.awt.geom.Area(new java.awt.geom.Ellipse2D.Float(38, 0, 12, 18));
        TUBE.add(TUBE_TOP);
        TUBE.add(TUBE_BOTTOM);


        /**
         * Tutorial Step 6.
         * Create and apply the left to right gradient
         */
        final java.awt.geom.Point2D START_LEFT = new java.awt.geom.Point2D.Float(0,0);
        final java.awt.geom.Point2D STOP_RIGHT = new java.awt.geom.Point2D.Float(86,0);

        final float[] FRACTIONS_LEFT_TO_RIGHT =
        {
            0.0f,
            0.15f,
            0.4f,
            0.6f,
            0.75f,
            1.0f
        };

        final java.awt.Color[] COLORS_LEFT_TO_RIGHT =
        {
            new java.awt.Color(0.0f, 0.0f, 0.0f, 0.5f),
            new java.awt.Color(0.0f, 0.0f, 0.0f, 0.3f),
            new java.awt.Color(0.0f, 0.0f, 0.0f, 0.1f),
            new java.awt.Color(0.0f, 0.0f, 0.0f, 0.1f),
            new java.awt.Color(0.0f, 0.0f, 0.0f, 0.3f),
            new java.awt.Color(0.0f, 0.0f, 0.0f, 0.5f)
        };

        final java.awt.LinearGradientPaint LEFT_TO_RIGHT_GRADIENT = new java.awt.LinearGradientPaint(START_LEFT, STOP_RIGHT, FRACTIONS_LEFT_TO_RIGHT, COLORS_LEFT_TO_RIGHT);

        g2.setPaint(LEFT_TO_RIGHT_GRADIENT);
        g2.fill(TUBE);


        /**
         * Tutorial Step 7.
         * Create and apply the top to bottom gradient
         */
        final java.awt.geom.Point2D START_TOP = new java.awt.geom.Point2D.Float(0,0);
        final java.awt.geom.Point2D STOP_BOTTOM = new java.awt.geom.Point2D.Float(0,146);

        final float[] FRACTIONS_TOP_TO_BOTTOM =
        {
            0.0f,
            0.9f,
            1.0f
        };

        final java.awt.Color[] COLORS_TOP_TO_BOTTOM =
        {
            new java.awt.Color(0.0f, 0.0f, 0.0f, 0.0f),
            new java.awt.Color(0.0f, 0.0f, 0.0f, 0.0f),
            new java.awt.Color(0.0f, 0.0f, 0.0f, 0.6f)
        };

        final java.awt.LinearGradientPaint TOP_TO_BOTTOM_GRADIENT = new java.awt.LinearGradientPaint(START_TOP, STOP_BOTTOM, FRACTIONS_TOP_TO_BOTTOM, COLORS_TOP_TO_BOTTOM);

        g2.setPaint(TOP_TO_BOTTOM_GRADIENT);
        g2.fill(TUBE);


        /**
         * Tutorial Step 8. - 9.
         * Create the side light reflection shape
         */
        final java.awt.geom.Area SIDE_LIGHT_EFFECT = new java.awt.geom.Area(new java.awt.geom.RoundRectangle2D.Float(3, 43, 36, 99, 18, 18));
        final java.awt.geom.Area EFFECT_SUB = new java.awt.geom.Area(new java.awt.geom.RoundRectangle2D.Float(7, 37, 36, 105, 18, 18));
        SIDE_LIGHT_EFFECT.subtract(EFFECT_SUB);


        /**
         * Tutorial Step 10.
         * Create and apply the side light gradient
         */
        final java.awt.geom.Point2D SIDE_LIGHT_EFFECT_START = new java.awt.geom.Point2D.Float(3, 0);
        final java.awt.geom.Point2D SIDE_LIGHT_EFFECT_STOP = new java.awt.geom.Point2D.Float(13, 0);

        final float[] SIDE_LIGHT_EFFECT_FRACTIONS =
        {
            0.0f,
            1.0f
        };

        final java.awt.Color[] SIDE_LIGHT_EFFECT_COLORS =
        {
            new java.awt.Color(1.0f, 1.0f, 1.0f, 0.5f),
            new java.awt.Color(1.0f, 1.0f, 1.0f, 0.0f)
        };

        final java.awt.LinearGradientPaint SIDE_LIGHT_EFFECT_GRADIENT = new java.awt.LinearGradientPaint(SIDE_LIGHT_EFFECT_START, SIDE_LIGHT_EFFECT_STOP, SIDE_LIGHT_EFFECT_FRACTIONS, SIDE_LIGHT_EFFECT_COLORS);

        g2.setPaint(SIDE_LIGHT_EFFECT_GRADIENT);
        g2.fill(SIDE_LIGHT_EFFECT);


        /**
         * Tutorial Step 11.
         * Create the top light effect ellipse
         */
        final java.awt.geom.Ellipse2D TOP_LIGHT_EFFECT = new java.awt.geom.Ellipse2D.Float(17, 11, 52, 21);


        /**
         * Tutorial Step 12.
         * Create and apply the top light gradient
         */
        final java.awt.geom.Point2D TOP_LIGHT_EFFECT_START = new java.awt.geom.Point2D.Float(0, 11);
        final java.awt.geom.Point2D TOP_LIGHT_EFFECT_STOP = new java.awt.geom.Point2D.Float(0, 32);

        final float[] TOP_LIGHT_EFFECT_FRACTIONS =
        {
            0.0f,
            1.0f
        };

        final java.awt.Color[] TOP_LIGHT_EFFECT_COLORS =
        {
            new java.awt.Color(1.0f, 1.0f, 1.0f, 0.5f),
            new java.awt.Color(1.0f, 1.0f, 1.0f, 0.0f)
        };

        final java.awt.LinearGradientPaint TOP_LIGHT_EFFECT_GRADIENT = new java.awt.LinearGradientPaint(TOP_LIGHT_EFFECT_START, TOP_LIGHT_EFFECT_STOP, TOP_LIGHT_EFFECT_FRACTIONS, TOP_LIGHT_EFFECT_COLORS);

        g2.setPaint(TOP_LIGHT_EFFECT_GRADIENT);
        g2.fill(TOP_LIGHT_EFFECT);


        /**
         * Tutorial Step 13.
         * Create the small light effect ellipse
         */
        final java.awt.geom.Ellipse2D SMALL_TOP_LIGHT_EFFECT = new java.awt.geom.Ellipse2D.Float(39, 3, 4, 6);


        /**
         * Tutorial Step 14.
         * Create and apply the small light effect gradient
         */
        final java.awt.geom.Point2D SMALL_TOP_LIGHT_EFFECT_START = new java.awt.geom.Point2D.Float(0, 3);
        final java.awt.geom.Point2D SMALL_TOP_LIGHT_EFFECT_STOP = new java.awt.geom.Point2D.Float(0, 9);

        final float[] SMALL_TOP_LIGHT_EFFECT_FRACTIONS =
        {
            0.0f,
            1.0f
        };

        final java.awt.Color[] SMALL_TOP_LIGHT_EFFECT_COLORS =
        {
            new java.awt.Color(1.0f, 1.0f, 1.0f, 0.3f),
            new java.awt.Color(1.0f, 1.0f, 1.0f, 0.0f)
        };

        final java.awt.LinearGradientPaint SMALL_TOP_LIGHT_EFFECT_GRADIENT = new java.awt.LinearGradientPaint(SMALL_TOP_LIGHT_EFFECT_START, SMALL_TOP_LIGHT_EFFECT_STOP, SMALL_TOP_LIGHT_EFFECT_FRACTIONS, SMALL_TOP_LIGHT_EFFECT_COLORS);

        g2.setPaint(SMALL_TOP_LIGHT_EFFECT_GRADIENT);
        g2.fill(SMALL_TOP_LIGHT_EFFECT);


        /**
         * Tutorial Step 15.
         * Creating the rectangle for the stripe light effect
         */
        final java.awt.geom.Rectangle2D STRIPE_LIGHT_EFFECT = new java.awt.geom.Rectangle2D.Float(13, 46, 62, 1);


        /**
         * Tutorial Step 16.
         * Create and apply the stripe light effect gradient
         */
        final java.awt.geom.Point2D STRIPE_LIGHT_EFFECT_START = new java.awt.geom.Point2D.Float(13, 0);
        final java.awt.geom.Point2D STRIPE_LIGHT_EFFECT_STOP = new java.awt.geom.Point2D.Float(75, 0);

        final float[] STRIPE_LIGHT_EFFECT_FRACTIONS =
        {
            0.0f,
            0.5f,
            1.0f
        };

        final java.awt.Color[] STRIPE_LIGHT_EFFECT_COLORS =
        {
            new java.awt.Color(1.0f, 1.0f, 1.0f, 0.0f),
            new java.awt.Color(1.0f, 1.0f, 1.0f, 0.5f),
            new java.awt.Color(1.0f, 1.0f, 1.0f, 0.0f)
        };

        final java.awt.LinearGradientPaint STRIPE_LIGHT_EFFECT_GRADIENT = new java.awt.LinearGradientPaint(STRIPE_LIGHT_EFFECT_START, STRIPE_LIGHT_EFFECT_STOP, STRIPE_LIGHT_EFFECT_FRACTIONS, STRIPE_LIGHT_EFFECT_COLORS);

        g2.setPaint(STRIPE_LIGHT_EFFECT_GRADIENT);
        g2.fill(STRIPE_LIGHT_EFFECT);


        // Free the reserved memory
        g2.dispose();


        // Return our little nixie glass tube image
        return IMAGE;
    }
}
